/******************************************************************************
 CListing.c

				CListing Document Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	Generated by Classy (Object Factory) 2:31 PM Mon, Sep 6, 1993

	This file is only generated once. You can modify it by filling
	in the placeholder functions and adding any new functions you wish.

	If you change the name of the document class, a fresh version of this
	file will be generated. If you have made any changes to the file
	with the old name, you will have to copy those changes to the new
	file by hand.

 ******************************************************************************/

#include "CListing.h"
//#include "AppCommands.h"			// Remove comments if DoCommand overridden

#include <CApplication.h>
#include <CEditText.h>
#include <CDataFile.h>
#include <CFileStream.h>

/**** Font Defaults ****/
#define kDefaultFont	geneva
#define kDefaultSize	10


/**** C O N S T R U C T I O N / D E S T R U C T I O N   M E T H O D S ****/


/******************************************************************************
 ICListing

	Initialize the document

	IMPORTANT NOTE: When an object is initialized as part of a
	'CVue' resource, this I-function is NEVER CALLED. Instead,
	the object is initialized in its GetFrom method(s). To add your
	own initialization, override GetFrom.

 ******************************************************************************/

void CListing::ICListing()

{
	Ix_CListing();

		// Initialize data members here
	itsText = NULL;
	itsFont = kDefaultFont;			// defaults
	itsSize = kDefaultSize;
}


/******************************************************************************
 MakeNewContents

	Create "blank" document contents. MakeNewContents is called
	after itsWindow is created and before it is first selected,
	whether or not the document uses a file.
 ******************************************************************************/

void CListing::MakeNewContents()

{
	itsText = NewHandle(0);
	itsFont = kDefaultFont;			// defaults
	itsSize = kDefaultSize;
}


/******************************************************************************
 ContentsToWindow
 
 	Make window reflect document's contents.  If the document does
 	not use a file, this function is never called and may be deleted.
******************************************************************************/

void CListing::ContentsToWindow()

{
	fListing_Pano1->SetTextHandle(itsText);

	// set the font/size into the text edit field
	fListing_Pano1->SetFontNumber(itsFont);
	fListing_Pano1->SetFontSize(itsSize);
}


/******************************************************************************
 WindowToContents
 
 	Make document's contents reflect window's contents (if they
 	don't already).  If the document does not use a file, this
 	function is never called and may be deleted.
******************************************************************************/

void CListing::WindowToContents()

{
		// Transfer data from itsWindow to itsContents
}

/******************************************************************************
 ReadContents

	Read the contents of a document.  Subclass may override.
 ******************************************************************************/

void	CListing::ReadContents(CFileStream *aStream)
{
	CDataFile *file;

	itsFont = kDefaultFont;			// defaults
	itsSize = kDefaultSize;

	file = aStream->GetFile();
	ForgetHandle(itsText);
	itsText = file->ReadAll();
}

